<?php $this->load->view('includes/head'); ?>
<link href="https://unpkg.com/bootstrap-table@1.18.3/dist/extensions/reorder-rows/bootstrap-table-reorder-rows.css" rel="stylesheet">
</head>
<body>
  <div id="app">
    <div class="main-wrapper">
      <?php $this->load->view('includes/navbar'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <div class="section-header-back">
              <a href="javascript:history.go(-1)" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
            </div>
            <h1>
            <?=$this->lang->line('enquiries')?htmlspecialchars($this->lang->line('enquiries')):'Enquiries'?>
            </h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?=base_url()?>"><?=$this->lang->line('dashboard')?$this->lang->line('dashboard'):'Dashboard'?></a></div>
              <div class="breadcrumb-item"><?=$this->lang->line('enquiries')?htmlspecialchars($this->lang->line('enquiries')):'Enquiries'?></div>
            </div>
          </div>

          <div class="section-body">
            
            <?php if(!$this->ion_auth->in_group(3)){ ?> 
              <div class="row">
                <div class="col-md-12 form-group">
                  <select class="form-control select2 filter_change">
                    <?php foreach($my_all_cards as $my_all_card){ ?>
                    <option value="<?=base_url('cards/enquiries/'.$my_all_card['id'])?>" <?=($card['id'] == $my_all_card['id'])?"selected":""?>><?=htmlspecialchars($my_all_card['title'])?> - <?=htmlspecialchars($my_all_card['sub_title'])?></option>
                    <?php } ?>
                  </select>
                </div>
              </div>
            <?php } ?> 

            <div class="row">
              <div class="col-md-12">
                <div class="card card-primary">


                  <div class="card-body">
                    <table class='table-striped' id='enquiries_list'
                      data-toggle="table"
                      data-url="<?=base_url('cards/get_enquiries')?>"
                      data-click-to-select="true"
                      <?php if(isset($_GET['reorder'])){ ?>
                        data-use-row-attr-func="true"
                        data-reorderable-rows="true"
                      <?php } ?>

                      data-side-pagination="server"
                      data-pagination="false"
                      data-page-list="[5, 10, 20, 50, 100, 200]"
                      data-search="true" data-show-columns="true"
                      data-show-refresh="false" data-trim-on-search="false"
                      data-sort-name="order_by_id" data-sort-order="ASC"
                      data-mobile-responsive="true"
                      data-toolbar="" data-show-export="false"
                      data-maintain-selected="true"
                      data-export-types='["txt","excel"]'
                      data-export-options='{
                        "fileName": "enquiries-list",
                        "ignoreColumn": ["state"] 
                      }'
                      data-query-params="queryParams">
                      <thead>
                        <tr>
                          <th data-field="name" data-sortable="true"><?=$this->lang->line('name')?htmlspecialchars($this->lang->line('name')):'Name'?></th>

                          <th data-field="email" data-sortable="true"><?=$this->lang->line('email')?htmlspecialchars($this->lang->line('email')):'Email'?></th>

                          <th data-field="mobile" data-sortable="true" data-visible="false"><?=$this->lang->line('mobile')?htmlspecialchars($this->lang->line('mobile')):'Mobile'?></th>

                          <th data-field="msg" data-sortable="true"><?=$this->lang->line('message')?htmlspecialchars($this->lang->line('message')):'Message'?></th>

                          
                          <th data-field="created" data-sortable="true"  data-visible="false"><?=$this->lang->line('date')?htmlspecialchars($this->lang->line('date')):'Date'?></th>
                          
                          <th data-field="action" data-sortable="false"><?=$this->lang->line('action')?$this->lang->line('action'):'Action'?></th>

                        </tr>
                      </thead>
                    </table>
                  </div>
                  
                  <div class="card-footer bg-whitesmoke text-md-right">
                    <?php if(isset($card['slug']) && $card['slug'] != ''){ ?>
                      <a href="<?=base_url($card['slug'])?>" class="btn btn-icon icon-left btn-success copy_href"><i class="fas fa-copy"></i> <?=$this->lang->line('copy')?htmlspecialchars($this->lang->line('copy')):'Copy Card URL'?></a>
                      <a href="<?=base_url($card['slug'])?>" target="_blank" class="btn btn-icon icon-left btn-danger"><i class="fas fa-eye"></i> <?=$this->lang->line('preview')?htmlspecialchars($this->lang->line('preview')):'Preview'?></a>
                    <?php } ?>
                  </div>
                  
                </div>
              </div>
            </div>



          </div>
        </section>
      </div>
    
    <?php $this->load->view('includes/footer'); ?>
    </div>
  </div>

<?php $this->load->view('includes/js'); ?>

<script>
function queryParams(p){
	return {
		card_id:<?php echo $card['id']; ?>,
		limit:p.limit,
		sort:p.sort,
		order:p.order,
		offset:p.offset,
		search:p.search
	};
}
</script>

</body>
</html>