<?php $this->load->view('includes/head'); ?>
</head>
<body>
  <div id="app">
    <div class="main-wrapper">
      <?php $this->load->view('includes/navbar'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <div class="section-header-back">
              <a href="javascript:history.go(-1)" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
            </div>
            <h1>
            <?=$this->lang->line('verification')?htmlspecialchars($this->lang->line('verification')):'Verification'?>
            </h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?=base_url()?>"><?=$this->lang->line('dashboard')?$this->lang->line('dashboard'):'Dashboard'?></a></div>
              <div class="breadcrumb-item"><?=$this->lang->line('verification')?htmlspecialchars($this->lang->line('verification')):'Verification'?></div>
            </div>
          </div>



          <div class="section-body">

              <?php if($card){  if(!$this->ion_auth->in_group(3)){ ?> 
                <div class="row">
                  <div class="col-md-12 form-group">
                    <select class="form-control select2 filter_change">
                      <?php foreach($my_all_cards as $my_all_card){ ?>
                      <option value="<?=base_url('cards/verification/'.$my_all_card['id'])?>" <?=($card['id'] == $my_all_card['id'])?"selected":""?>><?=htmlspecialchars($my_all_card['title'])?> - <?=htmlspecialchars($my_all_card['sub_title'])?></option>
                      <?php } ?>
                    </select>
                  </div>
                </div>
              <?php } ?> 

              <form action="<?=base_url('cards/save')?>" method="POST" id="save_card" enctype="multipart/form-data">
                <input type="hidden" name="changes_type" value="verification">
                <input type="hidden" name="card_id" value="<?=$card['id']?>">


                
                <div class="card author-box card-primary">
                  <div class="card-body">
                    <div class="author-box-left">
                      <img alt="Profile" src="<?=($card['profile'] != '' && file_exists('assets/uploads/card-profile/'.htmlspecialchars($card['profile'])))?base_url('assets/uploads/card-profile/'.htmlspecialchars($card['profile'])):base_url('assets/uploads/logos/'.half_logo())?>" class="rounded-circle author-box-picture">
                      <div class="clearfix"></div>

                        <?php if($card['verification_status'] == 0){ ?>
                            <a href="#" class="btn btn-danger mt-3">
                              <?=$this->lang->line('not_verified')?$this->lang->line('not_verified'):'Not Verified'?>
                            </a>
                        <?php }elseif($card['verification_status'] == 1){ ?>
                            <a href="#" class="btn btn-success mt-3">
                            <?=$this->lang->line('verified')?$this->lang->line('verified'):'Verified'?>
                            </a>
                        <?php }else{ ?>
                            <a href="#" class="btn btn-warning mt-3">
                            <?=$this->lang->line('under_review')?$this->lang->line('under_review'):'Under Review'?>
                            </a>
                        <?php } ?>
                      
                    </div>

                    
                    <div class="author-box-details">
                      <div class="author-box-name">
                        <a target="_blank" href="<?=base_url(htmlspecialchars($card['slug']))?>"><?=htmlspecialchars($card['title'])?></a>
                      </div>
                      <div class="author-box-job"><?=htmlspecialchars($card['sub_title'])?></div>
                      <div class="author-box-description">
                        <p><?=htmlspecialchars($card['description'])?></p>
                      </div>
                    </div>
                  </div>
                </div>

                <?php if($card['verification_status'] == 2){ ?>
                  <h2 class="section-title"><?=$this->lang->line('note')?htmlspecialchars($this->lang->line('note')):"Note"?></h2>
                  <p class="section-lead text-danger"><?=$this->lang->line('we_have_received_your_documents_for_verification_you_will_be_notified_of_your_verification_status_once_the_process_is_complete
')?$this->lang->line('we_have_received_your_documents_for_verification_you_will_be_notified_of_your_verification_status_once_the_process_is_complete
'):'We have received your documents for verification. You will be notified of your verification status once the process is complete.'?></p>

                <?php } ?>

                <?php if($card['verification_status'] == 0){ ?>


                  
                <h2 class="section-title"><?=$this->lang->line('documents')?$this->lang->line('documents'):'Documents'?></h2>
                <p class="section-lead text-danger"><?=$this->lang->line('upload_any_supporting_documents_such_as_a_passport_driving_license_or_business_registration_for_verification_of_your_vcard')?$this->lang->line('upload_any_supporting_documents_such_as_a_passport_driving_license_or_business_registration_for_verification_of_your_vcard'):'Upload any supporting documents, such as a passport, driving license, or business registration, for verification of your vCard. (jpg|png|jpeg)'?></p>

                <div class="card card-primary" id="save_card_card">
                  <div class="card-body">

                    <div class="row">

                      <span class="col-md-6 mb-4">
                        <span class="row">
                          <div class="form-group col-md-6">
                            <label class="form-label"><?=$this->lang->line('front')?$this->lang->line('front'):'Front'?> <span class="text-danger">*</span></label>
                            <input type="file" name="front" class="form-control">
                            <input type="hidden" name="old_front" value="<?=isset($card['verification_doc']['front'])?htmlspecialchars($card['verification_doc']['front']):''?>">
                          </div>
                          <?php if(isset($card['verification_doc']['front']) && !empty($card['verification_doc']['front']) && file_exists('assets/uploads/card-verification-doc/'.htmlspecialchars($card['verification_doc']['front']))){ ?>
                            <div class="form-group col-md-6 my-auto">
                              <img alt="Front" src="<?=base_url('assets/uploads/card-verification-doc/'.htmlspecialchars($card['verification_doc']['front']))?>" class="system-logos" style="width: 45%;">
                            </div>
                          <?php } ?>
                        </span>
                      </span>

                      <span class="col-md-6 mb-4">
                        <span class="row">
                          <div class="form-group col-md-6">
                            <label class="form-label"><?=$this->lang->line('back')?htmlspecialchars($this->lang->line('back')):'Back'?></label>
                            <input type="file" name="back" class="form-control">
                            <input type="hidden" name="old_back" value="<?=isset($card['verification_doc']['back'])?htmlspecialchars($card['verification_doc']['back']):''?>">
                          </div>
                          <?php if(isset($card['verification_doc']['back']) && !empty($card['verification_doc']['back']) && file_exists('assets/uploads/card-verification-doc/'.htmlspecialchars($card['verification_doc']['back']))){ ?>
                            <div class="form-group col-md-6 my-auto">
                              <img alt="Back" src="<?=base_url('assets/uploads/card-verification-doc/'.htmlspecialchars($card['verification_doc']['back']))?>" class="system-logos" style="width: 45%;">
                            </div>
                          <?php } ?>
                        </span>
                      </span>
                    

                  </div>
                  <div class="card-footer bg-whitesmoke text-md-right">
                    <button class="btn btn-primary savebtn"><?=$this->lang->line('send_for_review')?$this->lang->line('send_for_review'):'Send for Review'?></button>
                  </div>
                  <div class="result"></div>
                </div>


                <?php } ?>

              </form>

              <?php }else{ ?> 
                <div class="row">
                  <div class="col-12 col-md-12 col-sm-12">
                    <div class="card">
                      <div class="card-body">
                        <div class="empty-state" data-height="400" style="height: 400px;">
                          <h2><?=$this->lang->line('no_card_found')?$this->lang->line('no_card_found'):'No card found'?></h2>
                          <p class="lead">
                          <?=$this->lang->line('create_a_card_and_come_back_here')?$this->lang->line('create_a_card_and_come_back_here'):'Create a card and come back here.'?>
                          </p>
                          <a href="<?=base_url('cards');?>" class="btn btn-primary mt-4"><?=$this->lang->line('create')?htmlspecialchars($this->lang->line('create')):'Create'?></a>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              <?php } ?> 

          </div>
        </section>
      </div>
    
    <?php $this->load->view('includes/footer'); ?>
    </div>
  </div>


<?php $this->load->view('includes/js'); ?>

</body>
</html>